/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.input;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ShortcutInput
extends TextInput {
    private Listener listener = new MyListener();
    private KeyStroke value = null;

    public ShortcutInput(String value) {
        this(SWTUtil.getKeyStroke(StringUtils.trimToNull((String)value)));
    }

    public ShortcutInput(KeyStroke value) {
        super("");
        this.setValue(value);
        this.setHint(Application.getI18n().tr("<Hier klicken und Tastek\u00fcrzel dr\u00fccken>"));
        this.setName(Application.getI18n().tr("Tastenk\u00fcrzel"));
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        String s;
        if (value instanceof KeyStroke) {
            this.value = (KeyStroke)value;
            super.setValue(this.value.format());
            return;
        }
        String string = s = value != null ? StringUtils.trimToNull((String)value.toString()) : null;
        if (s == null) {
            this.value = null;
            super.setValue(null);
            return;
        }
        this.value = SWTUtil.getKeyStroke(s);
        super.setValue(this.value != null ? this.value.format() : null);
    }

    @Override
    protected Text getTextWidget() {
        if (this.text != null) {
            return this.text;
        }
        Text text = super.getTextWidget();
        final Display display = GUI.getDisplay();
        text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                display.removeFilter(2, ShortcutInput.this.listener);
            }

            public void focusGained(FocusEvent e) {
                display.addFilter(2, ShortcutInput.this.listener);
            }
        });
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                display.removeFilter(2, ShortcutInput.this.listener);
            }
        });
        return text;
    }

    private class MyListener
    implements Listener {
        private MyListener() {
        }

        public void handleEvent(Event event) {
            if (ShortcutInput.this.text == null || ShortcutInput.this.text.isDisposed()) {
                return;
            }
            int i = event.keyCode;
            if ((i & 0x10000) != 0 || (i & 0x40000) != 0 || (i & 0x20000) != 0) {
                return;
            }
            if (event.stateMask == 0) {
                ShortcutInput.this.setValue(null);
                return;
            }
            try {
                KeyStroke ks = KeyStroke.getInstance((int)event.stateMask, (int)event.keyCode);
                if (ks.isComplete()) {
                    ShortcutInput.this.setValue(ks);
                }
            }
            catch (Exception e) {
                Logger.error((String)"invalid shortcut", (Throwable)e);
            }
        }
    }
}

